//	OTLN_CTopic.h

#ifndef _H_O_CTopic
#define _H_O_CTopic

#include "O_p.h"

#define		OTLN_CellRect_INDENTED_CELL		(OTLN_CellRect_NAME_NUMBER_ICON + 1)

Err				OTLNg_GetCTopic(OTLN_TopicH topic, OTLN_CTopic **ctopic);

/*****************************************************************************/
class	OTLN_CTopic {

	//DECLARE_RTTC(OTLN_CTopic);

/********  Initialize  **********/
public:
			//	pass either topicH0 or name0
			Err						OTLNm_ITopic(
						Err				*operator_err, 
						OTLN_TopicH		topicH0, 
				const	char			*name0
			);
			
/********  Duplicate  **********/
private:
	static	Err						OTLNspm_DuplicateSelfCB(
				//	always passed out, but may be ignored
				OTLN_OutlineAndTopic	*to_source0, 
				void					*custom_source, 
				//	always passed out, but may be ignored
				OTLN_OutlineAndTopic	*to_dest0, 
				void 					**custom_dest
			);
	
			Err						OTLNpm_DuplicateSelf(
				OTLN_OutlineAndTopic	*source_ot, 
				OTLN_OutlineAndTopic	*dest_ot, 
				OTLN_CTopic				**duplicate
			);
		
public:
			Err						OTLNm_Duplicate(OTLN_CTopic **duplicate);

/********  Dispose  **********/
private:
	static	Err						OTLNspm_DisposeSelfCB(void *custom_data);
			Err						OTLNpm_DisposeSelf(void);

public:
			//	DisposeOutline returns an ERROR!   
			//	this is the one you must call!!!
			Err						OTLNm_DisposeTopic(void);
			
			//	Dispose does NOT return an error!!!
			//	be forwarned!  Don't call it!
			void					Dispose(void);

/********  Hit Test  **********/
			Err						OTLNm_HitTest(Point hit_point, Boolean *hit);
			
/********  Draw  **********/
	Err			OTLNm_Draw(Boolean scrub);
	Err			OTLNm_DrawFromHere(long *bottom);

	Err			OTLNm_GetPaneFrame(Rect *rect);
	Err			OTLNm_GetTopicRect(OTLN_CellRectType cellType, Rect *the_rect);

	Err			OTLNm_DrawTwirlieArrow(Rect *the_rect);
	Err			OTLNm_DrawName(Rect *the_rect);
	Err			OTLNm_DrawTopicDefault(void);

/********  User Callbacks, Custom Data  **********/
		Err				OTLNm_SetCallbackDispatch(
							OTLN_CBDispatchProc user_cb_dispatch_proc
						);
						
		Err				OTLNm_GetCallbackDispatch(
							OTLN_CBDispatchProc *user_cb_dispatch_proc
						);
						
		Err				OTLNm_SetCustomData(void *custom_data);
		Err				OTLNm_GetCustomData(void **custom_data);

/********  set specs  **********/
		Err				OTLNm_SetSpecs(
			const	char				*name0,
					short				cell_height_multiple0, 
					OTLN_TopicFlags		*flags0
		);
		
		Err				OTLNm_GetSpecs(
					char				*name0,
					short				*cell_height_multiple0, 
					OTLN_TopicFlags		*flags0
		);
		
		Err				OTLNm_SetName(const char *name);
		Err				OTLNm_GetName(char *name);
		
		//	way to set/get the font info
	
		Err				OTLNm_SetFontStyle(short style);

/********  creating the outline  **********/
	Err			OTLNm_SetRecent(void);	//	sets THIS to recent
	Err			OTLNm_Adopt(
		OTLN_COutline		*owner, 
		OTLN_CTopic			*parent, 
		OTLN_CTopicIndex	index
	);
	Err			OTLNm_Orphan(void);

	Err			OTLNm_Insert(void);
	Err			OTLNm_Remove(void);
	
	Err			OTLNm_MoveChildren(
		OTLN_CTopic	*srcParentP, 
		OTLN_CTopic	*dstParentP);

/********  drag reorder stuff, operates on children  **********/
private:
	static	Err		OTLNspm_DragReorderMessageCB(
		OTLN_DragReorderCBMessageType	message, 
		OTLN_DragReorderDataRec			*drag_data, 
		void							*user_data
	);

public:
	Err			OTLNm_DragReorder(
		Point					hit_point, 
		long					cell_height0, 
		OTLN_CTopicIndex		oldIndex, 		//	must pass this in
		OTLN_CTopicIndex		*newIndex
	);
	
	Err			OTLNm_ReOrder(
		OTLN_CTopicIndex	oldIndex,
		OTLN_CTopicIndex	newIndex
	);
	
	
/********  access  **********/
	Err			OTLNm_GetOutline(OTLN_COutline **coutline);

	Err			OTLNm_IsRootTopic(Boolean *is_root);
	Err			OTLNm_IsFirstTopic(Boolean *is_first);

	Err			OTLNm_GetParent(OTLN_CTopic **ctopic);
	Err			OTLNm_GetFirstSister(OTLN_CTopic **ctopic);
	Err			OTLNm_GetPrevSister(OTLN_CTopic **ctopic);
	Err			OTLNm_GetNextSister(OTLN_CTopic **ctopic);
	Err			OTLNm_GetLastSister(OTLN_CTopic **ctopic);

/*
	use
	GetIndTopic(OTLN_CTopicIndex_START, OTLN_CTopic **topic);
	Err			GetFirstDaughter(OTLN_CTopic **topic);
	
	GetIndTopic(OTLN_CTopicIndex_END, OTLN_CTopic **topic);
	Err			GetLastDaughter(OTLN_CTopic **topic);
*/	
	Err			OTLNm_TwirledDown(Boolean *cur_setting0, Boolean *new_setting0);
	Err			OTLNm_FamilyVisible(Boolean *cur_setting0, Boolean *new_setting0);
	Err			OTLNm_TopicOnscreen(Boolean *onscreen);
	Err			OTLNm_TopicVisible(Boolean *cur_setting0, Boolean *new_setting0);
	Err			OTLNm_Solo(Boolean *cur_setting0, Boolean *new_setting0);
	Err			OTLNm_HasSeparator(Boolean *cur_setting0, Boolean *new_setting0);
	Err			OTLNm_HasNumber(Boolean *cur_setting0, Boolean *new_setting0);

	Err			OTLNm_CountTopics(OTLN_CTopicIndex *count);

	//	selects self unless == i_selectionException
	//	returns MY index
	Err			OTLNm_GetTopicIndex(OTLN_CTopicIndex *index);
	
	//	gets child[index]
	Err			OTLNm_GetIndTopic(OTLN_CTopicIndex index, OTLN_CTopic **ctopic);

	Err			OTLNm_CountVisibleCellsFromHere(long *pixels);
	Err			OTLNm_HitTestFromHere(Point hit_point, OTLN_CTopic **cTopic);

/********  selection  **********/
	Err			OTLNm_SelectAll(
		Boolean		select, 
		Boolean		draw
	);

	Err			OTLNm_Select(
		Boolean		select, 
		Boolean		draw
	);
	
	Err			OTLNm_Selected(Boolean *cur_setting0, Boolean *new_setting0);
	Err			OTLNm_CountSelectedTopics(OTLN_CTopicIndex *count);
	Err			OTLNm_GetIndSelectedTopic(OTLN_CTopicIndex index, OTLN_CTopic **ctopic);
	

/********  iterate  **********/

private:
	Err				OTLNpm_ApplyToItemsR(
		OTLN_IterateVarsP	gvars, 
		short				h_pos, 
		Boolean				hidden
	);

public:
	Err				OTLNm_ApplyToItems(
		OTLN_COutlineIterateType	iterate_type, 
		OTLN_CBType					cb_type, 
		void						*data, 
		Boolean						go_wide, 
		Boolean						go_deep
	);
	
/********  variables  **********/
	Err						*OTLNpi_operator_err;
	
	OTLN_CBDispatchProc		OTLNpi_user_cb_dispatch_proc;
	void					*OTLNpi_custom_data;
	
	OTLN_TopicH				OTLNpi_topicH;
	Boolean					OTLNpi_disposing;
	
	//	the following variables are ONLY valid when the topic 
	//	has been Adopted but not Interted, -OR- when it 
	//	has been Removed but not Orphaned.  all other times
	//	eg: when part of an outline, when just created, etc, 
	//	DO NOT rely on these being up to date
	OTLN_COutline		*OTLNpi_cOutline;
	OTLN_CTopic			*OTLNpi_parent0;	//	NULL means Root
	OTLN_CTopicIndex	OTLNpi_index;
};

#define		OTLN_FOR_EACH_OBJECT(MOTHER_C_TOPIC, TOPIC_INDEX, TOPIC, ERR)			\
	OTLN_TopicH		__topicH;														\
																					\
	OTLN_FOR_EACH((MOTHER_C_TOPIC)->OTLNpi_topicH, TOPIC_INDEX, __topicH, ERR) {	\
		ERR = OTLNg_GetCTopic(__topicH, &TOPIC);									\
		if (!ERR) {

#define		OTLN_END_EACH_OBJECT(TOPIC_INDEX, ERR)							\
		}																	\
	} OTLN_END_EACH(TOPIC_INDEX, __topicH, ERR)

#endif
